﻿$(function () {
    debugger;
    //Define the Global Variables across functions.
    var bingMapsKey = 'Av5A7yAWKLOF6lCCjOLl0I4tUh5b6ZP9c25PHmLrQF9zJGpW7lnYPAvm1Odo52VV';
    var map, locs, pins, startingPin, providersList, listItems, infobox, clusterInfobox, searchManager, orgUrl, webAPIUrl, searchLocation, veteranLocation, sortBySelection, qualityRanking, hsrmText, searchLocality, userQueryId, fetchXmlEncoded;
    var addressParam, taxonomyParam, radiusParam;
    var specialtySearch = new String();
    var providerNetworkSearch = new String();
    var providerRelationshipSearch = new String();
    var taxonomies = new Array();
    var providerNetworks = new Array();
    var providerRelationships = new Array();
    var descriptionsArray = new Array();
    var providerDescription = new String();
    var male = false;
    var female = false;
    var primarycare = false;
    var acceptingnew = false;
    var hsrm = false;

    //We will load the map and other fucntions once the HTML page has finished loading. 
    document.onreadystatechange = function () {
        if (document.readyState == "complete") {
            startMap();
        }
    }

    function getParameters() {
        //Get query string parameters and load them
        //into the vals array
        var vals = new Array();
        if (location.search != "") {
            vals = location.search.substr(1);
            //Get the view Id here.
            addressParam = vals.replace('Data=', '');
            //Decode the Address? 
            $('#searchBox')[0].value = addressParam;
            startMap();

        }
        else {
            startMap();
        }
    }

    function startMap() {

        // Load the map.
        map = new Microsoft.Maps.Map(document.getElementById('myMap'),
            {
                credentials: bingMapsKey,
                //center: new Microsoft.Maps.Location(38.890369, -77.031960),
                mapTypeId: Microsoft.Maps.MapTypeId.road,
                zoom: 12
            });

        // A setting for specifying the distance units displayed. Possible values are 'km' and 'mi'.
        var distanceUnits = 'mi';

        orgUrl = window.parent.Xrm.Page.context.getClientUrl();
        webAPIUrl = orgUrl + "/api/data/v8.2/";

        // Create a global infobox control.
        infobox = new Microsoft.Maps.Infobox(new Microsoft.Maps.Location(0, 0),
            {
                visible: false,
                offset: new Microsoft.Maps.Point(0, 20),
                height: 230,
                width: 230
            });
        infobox.setOptions({ showPointer: true, showCloseButton: true, maxHeight: 500, maxWidth: 400 });
        infobox.setMap(map);

        //Create a global clusterInfobox control
        clusterInfobox = new Microsoft.Maps.Infobox(new Microsoft.Maps.Location(0, 0),
            {
                visible: false,
                offset: new Microsoft.Maps.Point(0, 20),
                height: 230,
                width: 230
            });
        clusterInfobox.setOptions({ showPointer: true, showCloseButton: true, maxHeight: 300, maxWidth: 400 });
        clusterInfobox.setMap(map);

        // Create a session key from the map to use with data source service requests.
        var sessionKey;
        map.getCredentials(function (c) {
            sessionKey = c;
        });

        Microsoft.Maps.loadModule('Microsoft.Maps.Clustering');

        // Load the Search Module for Bing Maps for doing geocoding.
        Microsoft.Maps.loadModule('Microsoft.Maps.Search',
            {
                callback: function () {
                    searchManager = new Microsoft.Maps.Search.SearchManager(map);
                }
            });

        Microsoft.Maps.loadModule('Microsoft.Maps.AutoSuggest', function () {
            var suggestOptions = {
                addressSuggestions: true,
                autoDetectLocation: true,
                placeSuggestions: true,
                maxResults: 4,
                map: map
            };
            var manager = new Microsoft.Maps.AutosuggestManager(suggestOptions);
            manager.attachAutosuggest('#searchBox', '#searchSuggestion');
        });

        // Resize the height of the results panel based on the available space.

        $(window).resize(function () {
            $('.resultsPanel').height($(window).height() - $('.searchBar').height() - 360);
            $('.mapPanel').height($(window).height() - 360);
            $('.sidePanel').height($(window).height() - 360);
        });
        $(window).resize();

        /*
        $('select.specialtyLookupClass').select2({
            minimumInputLength: 2,
            tags: [],
            ajax: {
                type: "GET",
                contentType: "application/json; charset=utf-8",
                datatype: "json",
                delay: 250,
                url: function (params) {
                    var url = "https://dvagov-ppms-dev.api.crm9.dynamics.com/api/data/v8.2/ppms_taxonomies?$filter=startswith(ppms_codedspecialty,'" + params.term + "')";
                    return url;
                },
                processResults: function (data) {
                    var stuff = data;
                    return {
                        results: data
                    };
                },
                cache: true
            },         
        });
        */

        // A simple function for displaying error messages in the app.
        function showErrorMsg(msg) {
            $('.resultsPanel').html('<span class="alert alert-danger">' + msg + '</span>');
        }

        // A simple function for clearing the map and results panel.
        function clearMapAndResultsPanel() {

            map.layers.clear();
            infobox.setOptions({ visible: false });
            clusterInfobox.setOptions({ visible: false });
            $('.resultsPanel').html('');
            document.getElementById('loaderTitle').style.display = 'none';
            document.getElementById('loader').style.display = 'none';
            document.getElementById('resultsPanel').style.display = 'none';
            locs = [];
            pins = [];
            startingPin = [];
            listItems = [];
        }

        // Formats a time in 1000 hours to hh:mm AM/PM format
        function formatTime(val) {
            var minutes = val % 100;
            var hours = Math.round(val / 100);

            if (minutes == 0) {
                minutes = '00';
            }

            if (hours > 12) {
                return (hours - 12) + ':' + minutes + 'PM';
            } else {
                return hours + ':' + minutes + 'AM';
            }
        }

        function getBounds(lat1, lon1, brng, dist) {
            var a = 6378137,
                b = 6356752.3142,
                f = 1 / 298.257223563, // WGS-84 ellipsiod
                s = dist,
                alpha1 = toRad(brng),
                sinAlpha1 = Math.sin(alpha1),
                cosAlpha1 = Math.cos(alpha1),
                tanU1 = (1 - f) * Math.tan(toRad(lat1)),
                cosU1 = 1 / Math.sqrt((1 + tanU1 * tanU1)), sinU1 = tanU1 * cosU1,
                sigma1 = Math.atan2(tanU1, cosAlpha1),
                sinAlpha = cosU1 * sinAlpha1,
                cosSqAlpha = 1 - sinAlpha * sinAlpha,
                uSq = cosSqAlpha * (a * a - b * b) / (b * b),
                A = 1 + uSq / 16384 * (4096 + uSq * (-768 + uSq * (320 - 175 * uSq))),
                B = uSq / 1024 * (256 + uSq * (-128 + uSq * (74 - 47 * uSq))),
                sigma = s / (b * A),
                sigmaP = 2 * Math.PI;
            while (Math.abs(sigma - sigmaP) > 1e-12) {
                var cos2SigmaM = Math.cos(2 * sigma1 + sigma),
                    sinSigma = Math.sin(sigma),
                    cosSigma = Math.cos(sigma),
                    deltaSigma = B * sinSigma * (cos2SigmaM + B / 4 * (cosSigma * (-1 + 2 * cos2SigmaM * cos2SigmaM) - B / 6 * cos2SigmaM * (-3 + 4 * sinSigma * sinSigma) * (-3 + 4 * cos2SigmaM * cos2SigmaM)));
                sigmaP = sigma;
                sigma = s / (b * A) + deltaSigma;
            };
            var tmp = sinU1 * sinSigma - cosU1 * cosSigma * cosAlpha1,
                lat2 = Math.atan2(sinU1 * cosSigma + cosU1 * sinSigma * cosAlpha1, (1 - f) * Math.sqrt(sinAlpha * sinAlpha + tmp * tmp)),
                lambda = Math.atan2(sinSigma * sinAlpha1, cosU1 * cosSigma - sinU1 * sinSigma * cosAlpha1),
                C = f / 16 * cosSqAlpha * (4 + f * (4 - 3 * cosSqAlpha)),
                L = lambda - (1 - C) * f * sinAlpha * (sigma + C * sinSigma * (cos2SigmaM + C * cosSigma * (-1 + 2 * cos2SigmaM * cos2SigmaM))),
                revAz = Math.atan2(sinAlpha, -tmp); // final bearing

            var latitude = toDeg(lat2);
            var longitude = lon1 + toDeg(L);
            return new Microsoft.Maps.Location(latitude, longitude);
        };

        function toRad(n) {
            return n * Math.PI / 180;
        };
        function toDeg(n) {
            return n * 180 / Math.PI;
        };

        // Calculates the shortest distance between two locations on the curvature of the earth.
        function haversineDistance(loc1, loc2) {
            var degToRad = Math.PI / 180,
                lat1 = loc1.latitude * degToRad,
                lon1 = loc1.longitude * degToRad,
                lat2 = loc2.latitude * degToRad,
                lon2 = loc2.longitude * degToRad;

            var dLat = lat2 - lat1,
                dLon = lon2 - lon1,
                cordLength = Math.pow(Math.sin(dLat / 2), 2) +
                    Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin(dLon / 2), 2),
                centralAngle = 2 * Math.atan2(Math.sqrt(cordLength), Math.sqrt(1 - cordLength));

            var earthRadius = (distanceUnits == 'km') ? 6378.1 : 3963.1676;
            var distance = earthRadius * centralAngle;

            // Round off distance to 2 decimal place
            return Math.round(distance * 100) / 100;
        }

        // Add a key press event to the search box that triggers the search when the user presses Enter key.
        $('#specialtySearchBox').keypress(function (e) {
            if (e.which == 13) {
                $('#specialtySearchButton').click();
            }
        });

        // Add a click event to the search button.
        $('#specialtySearchButton').click(function () {
            //$('#specialtySearchBox')[0].value = "";
            specialtySearch = $('#specialtySearchBox')[0].value;
            taxonomies = [];
            var objectTypeCode = "";
            if (Mscrm.XrmInternal.getEntityCode != null && Mscrm.XrmInternal.getEntityCode != undefined)
                objectTypeCode = Mscrm.XrmInternal.getEntityCode("ppms_taxonomy");
            else
                objectTypeCode = Mscrm.XrmInternal.prototype.getEntityCode("ppms_taxonomy");

            var DialogOptions = new window.parent.Xrm.DialogOptions();
            DialogOptions.width = 800;
            DialogOptions.height = 600;

            var url = orgUrl + "/_controls/lookup/lookupmulti.aspx?class=null&objecttypes=" + objectTypeCode + "&browse=0&ShowNewButton=0&ShowPropButton=1&DefaultType=0" + "&search=" + specialtySearch;

            window.parent.Xrm.Internal.openDialog(url, DialogOptions, null, null, CallbackFunction);

            function CallbackFunction(event) {
                if (event.items.length != 0) {
                    var specialties = event.items;
                    var name = new String();

                    //Check for how many Specialties have been selected. 
                    if (specialties.length > 20) {
                        document.getElementById('loaderTitle').style.display = 'none';
                        document.getElementById('loader').style.display = 'none';
                        document.getElementById('resultsPanel').style.display = 'block';
                        showErrorMsg('A maximum of 20 specialties can be selected for search.');

                    }

                    for (var s = 0; s < specialties.length; s++) {
                        name += event.items[s].name;
                        var taxonomyId = event.items[s].id.replace(/[{}]/g, "");
                        taxonomies.push(taxonomyId);
                        if (s != specialties.length - 1) { name += ", " };
                    }
                    $('#specialtySearchBox')[0].value = name;
                    specialtySearch = $('#specialtySearchBox')[0].value;
                }
            }
        });

        // Add a key press event to the search box that triggers the search when the user presses Enter key.
        $('#providerNetworkSearchBox').keypress(function (e) {
            if (e.which == 13) {
                $('#providerNetworkSearchButton').click();
            }
        });

        // Add a click event to the search button.
        $('#providerNetworkSearchButton').click(function () {

            providerNetworkSearch = $('#providerNetworkSearchBox')[0].value;
            providerNetworks = [];
            var objectTypeCode = "";
            if (Mscrm.XrmInternal.getEntityCode != null && Mscrm.XrmInternal.getEntityCode != undefined)
                objectTypeCode = Mscrm.XrmInternal.getEntityCode("ppms_vaprovidernetwork");
            else
                objectTypeCode = Mscrm.XrmInternal.prototype.getEntityCode("ppms_vaprovidernetwork");

            var DialogOptions = new window.parent.Xrm.DialogOptions();
            DialogOptions.width = 800;
            DialogOptions.height = 600;

            var url = orgUrl + "/_controls/lookup/lookupmulti.aspx?class=null&objecttypes=" + objectTypeCode + "&browse=0&ShowNewButton=0&ShowPropButton=1&DefaultType=0" + "&search=" + providerNetworkSearch;

            window.parent.Xrm.Internal.openDialog(url, DialogOptions, null, null, CallbackFunction);

            function CallbackFunction(event) {
                if (event.items.length != 0) {
                    var networks = event.items;
                    var name = new String();

                    //Check for how many Netowrks have been selected. 
                    if (networks.length > 20) {
                        document.getElementById('loaderTitle').style.display = 'none';
                        document.getElementById('loader').style.display = 'none';
                        document.getElementById('resultsPanel').style.display = 'block';
                        showErrorMsg('A maximum of 20 Provider Networks can be selected for search.');

                    }

                    for (var s = 0; s < networks.length; s++) {
                        name += event.items[s].name;
                        var networkId = event.items[s].id.replace(/[{}]/g, "");
                        providerNetworks.push(networkId);
                        if (s != networks.length - 1) { name += ", " };
                    }
                    $('#providerNetworkSearchBox')[0].value = name;
                    providerNetworkSearch = $('#providerNetworkSearchBox')[0].value;
                }
            }
        });

        // Add a key press event to the search box that triggers the search when the user presses Enter key.
        $('#providerRelationshipSearchBox').keypress(function (e) {
            if (e.which == 13) {
                $('#providerRelationshipSearchButton').click();
            }
        });

        // Add a click event to the search button.
        $('#providerRelationshipSearchButton').click(function () {

            providerRelationshipSearch = $('#providerRelationshipSearchBox')[0].value;
            providerRelationships = [];
            var objectTypeCode = "";
            if (Mscrm.XrmInternal.getEntityCode != null && Mscrm.XrmInternal.getEntityCode != undefined)
                objectTypeCode = Mscrm.XrmInternal.getEntityCode("ppms_vaproviderrelationship");
            else
                objectTypeCode = Mscrm.XrmInternal.prototype.getEntityCode("ppms_vaproviderrelationship");

            var DialogOptions = new window.parent.Xrm.DialogOptions();
            DialogOptions.width = 800;
            DialogOptions.height = 600;

            var url = orgUrl + "/_controls/lookup/lookupmulti.aspx?class=null&objecttypes=" + objectTypeCode + "&browse=0&ShowNewButton=0&ShowPropButton=1&DefaultType=0" + "&search=" + providerRelationshipSearch;

            window.parent.Xrm.Internal.openDialog(url, DialogOptions, null, null, CallbackFunction);

            function CallbackFunction(event) {
                if (event.items.length != 0) {
                    var relationships = event.items;
                    var name = new String();

                    //Check for how many Relationships have been selected. 
                    if (relationships.length > 20) {
                        document.getElementById('loaderTitle').style.display = 'none';
                        document.getElementById('loader').style.display = 'none';
                        document.getElementById('resultsPanel').style.display = 'block';
                        showErrorMsg('A maximum of 20 Provider Relationships can be selected for search.');

                    }

                    for (var s = 0; s < relationships.length; s++) {
                        name += event.items[s].name;
                        var RelationshipId = event.items[s].id.replace(/[{}]/g, "");
                        providerRelationships.push(RelationshipId);
                        if (s != relationships.length - 1) { name += ", " };
                    }
                    $('#providerRelationshipSearchBox')[0].value = name;
                    providerRelationshipSearch = $('#providerRelationshipSearchBox')[0].value;
                }
            }
        });

        // Add a key press event to the search box that triggers the search when the user presses Enter key.
        $('#searchBox').keypress(function (e) {
            if (e.which == 13) {
                $('#searchBtn').click();
            }
        });

        // Add a click event to the search button.
        $('#searchBtn').click(function () {
            clearMapAndResultsPanel();
            document.getElementById('loaderTitle').style.display = 'block';
            document.getElementById('loader').style.display = 'block';
            //Filtering Options
            //Each time the Search Button is clicked we will recheck the Criteria selected by user.           
            //Reset the Provider Details each time. 
            male = false;
            female = false;
            primarycare = false;
            acceptingnew = false;
            hsrm = false;
            if ($.inArray("male", $('#providerDetailsSelection').val()) != -1) { male = true; }
            if ($.inArray("female", $('#providerDetailsSelection').val()) != -1) { female = true; }
            if ($.inArray("primarycare", $('#providerDetailsSelection').val()) != -1) { primarycare = true; }
            if ($.inArray("acceptingnew", $('#providerDetailsSelection').val()) != -1) { acceptingnew = true; }
            if ($.inArray("hsrm", $('#providerDetailsSelection').val()) != -1) { hsrm = true; }

            //Get the actual address entered in Searchbox for generating directions. The Geocoded searchLocation give's coordinates,
            //which do not work well passed into the Bing Directions URL. 
            veteranLocation = $('#searchBox').val();

            //Check for a value in the the Specialty Search box. 
            specialtySearch = $('#specialtySearchBox')[0].value;

            //Check for a value in the the Network Search box. 
            providerNetworkSearch = $('#providerNetworkSearchBox')[0].value;

            //Check for a value in the the Relationship Search box. 
            providerRelationshipSearch = $('#providerRelationshipSearchBox')[0].value;

            //Check for value in the Sort By field
            sortBySelection = $('#sortByCondition').find(":selected").val();

            //Check for a value in the Search Location Box. If empty give the user a message. 
            if ($('#searchBox').val() == null) {
                document.getElementById('loaderTitle').style.display = 'none';
                document.getElementById('loader').style.display = 'none';
                document.getElementById('resultsPanel').style.display = 'block';
                showErrorMsg('Address search location can not be empty.');
            }

            geocodeRequest();

            function geocodeRequest() {
                // Create a request to geocode the users search.
                var geocodeRequest = {
                    where: $('#searchBox').val(),
                    count: 1,
                    callback: function (r) {
                        if (r &&
                            r.results &&
                            r.results.length > 0 &&
                            r.results[0].location) {
                            searchLocation = r.results[0].location;
                            searchLocality = r.results[0].address.adminDistrict;
                            buildFetchXml();
                        } else {
                            document.getElementById('loaderTitle').style.display = 'none';
                            document.getElementById('loader').style.display = 'none';
                            document.getElementById('resultsPanel').style.display = 'block';
                            showErrorMsg('Unable to locate the given address.');
                        }
                    },
                    errorCallback: function () {
                        document.getElementById('loaderTitle').style.display = 'none';
                        document.getElementById('loader').style.display = 'none';
                        document.getElementById('resultsPanel').style.display = 'block';
                        showErrorMsg('Please enter a valid address into the search box.');
                    }
                };

                // Geocode the users search.
                searchManager.geocode(geocodeRequest);
            }

            function buildFetchXml() {

                var startLat = searchLocation.latitude;
                var startLong = searchLocation.longitude;

                //Convert miles to Meters for Coordinate Calc formula:
                var searchRadiusCalc = $('#radiusSelection').find(":selected").val();
                var distanceCalc = searchRadiusCalc * 1609.34;
                //Create Bounding Box Coordinates to narrow down results in the initial Fetch. 
                var northBoundCoord = getBounds(startLat, startLong, 0, distanceCalc);
                var eastBoundCoord = getBounds(startLat, startLong, 90, distanceCalc);
                var southBoundCoord = getBounds(startLat, startLong, 180, distanceCalc);
                var westBoundCoord = getBounds(startLat, startLong, 270, distanceCalc);

                //Build the FetchXml here for the savedview. 
                var fetchXml = new String();
                fetchXml =
                    '<fetch version="1.0" output-format="xml-platform" mapping="logical" distinct="true">' +
                    '<entity name="ppms_providerservice">' +
                    '<attribute name="ppms_name"/>' +
                    '<attribute name="ppms_caresiteaddress" />' +
                    '<attribute name="ppms_caresitecity" />' +
                    '<attribute name="ppms_caresitestateprovince" />' +
                    '<attribute name="ppms_caresitezipcode" />' +
                    '<attribute name="ppms_latitude" />' +
                    '<attribute name="ppms_longitude" />' +
                    '<attribute name="ppms_specialtynametext" />' +
                    '<attribute name="ppms_networknametext" />' +
                    '<attribute name="ppms_providername" />' +
                    '<attribute name="ppms_qualityrankingtotalscore" />' +
                    '<attribute name="ppms_workhours" />' +
                    '<attribute name="ppms_hsrm" />' +
                    '<attribute name="ppms_providerid" />' +
                    '<attribute name="ppms_providerserviceid" />' +
                    '<order attribute="ppms_name" descending="false" />' +
                    '<filter type="and">' +
                    '<condition attribute="statecode" operator="eq" value="0" />' +
                    '<condition attribute="statuscode" operator="eq" value="1" />' +
                    '<condition attribute="ppms_geocoded" operator="eq" value="1" />' +
                    '<condition attribute="ppms_addressvalidated" operator = "eq" value = "1" />' +
                    '<condition attribute="ppms_latitude" operator="not-null" />' +
                    '<condition attribute="ppms_longitude" operator="not-null" />' +
                    '<condition attribute="ppms_latitude" operator="lt" value="' + northBoundCoord.latitude + '"/>' +
                    '<condition attribute="ppms_latitude" operator="gt" value="' + southBoundCoord.latitude + '"/>' +
                    '<condition attribute="ppms_longitude" operator="gt" value="' + westBoundCoord.longitude + '"/>' +
                    '<condition attribute="ppms_longitude" operator="lt" value="' + eastBoundCoord.longitude + '"/>';

                //Provider Networks
                if (!!providerNetworkSearch && !!providerNetworks) {
                    if (providerNetworks.length > 1) { fetchXml += '<filter type="or">'; };
                    for (var n = 0; n < providerNetworks.length; n++) {
                        var networkId = providerNetworks[n];
                        fetchXml +=
                            '<condition attribute="ppms_network" operator="eq" uiname="" uitype="ppms_vaprovidernetwork" value="{' + networkId + '}" />';
                    };
                    if (providerNetworks.length > 1) { fetchXml += '</filter>'; };
                }

                //Provider Relationships
                if (!!providerRelationshipSearch && !!providerRelationships) {
                    if (providerRelationships.length > 1) { fetchXml += '<filter type="or">'; };
                    for (var n = 0; n < providerRelationships.length; n++) {
                        var relationshipId = providerRelationships[n];
                        fetchXml +=
                            '<condition attribute="ppms_vaproviderrelationshipid" operator="eq" uiname="" uitype="ppms_vaproviderrelationship" value="{' + relationshipId + '}" />';
                    };
                    if (providerRelationships.length > 1) { fetchXml += '</filter>'; };
                }

                //Specialties
                if (!!specialtySearch && !!taxonomies) {
                    if (taxonomies.length > 1) { fetchXml += '<filter type="or">'; };
                    for (var t = 0; t < taxonomies.length; t++) {
                        var taxonomyId = taxonomies[t];
                        fetchXml +=
                            '<condition attribute="ppms_specialty" operator="eq" uiname="" uitype="ppms_taxonomy" value="{' + taxonomyId + '}" />';
                    };
                    if (taxonomies.length > 1) { fetchXml += '</filter>'; };
                }
                fetchXml += '</filter>';

                //Add the filtering attributes from Provider (link entity)
                fetchXml += '<link-entity name="account" alias="am" to="ppms_providerid" from="accountid" ><filter type="and">';

                //Every Provider Needs to be in Active StateCode/StatusReason
                fetchXml += '<condition attribute="statecode" operator="eq" value="0" />';
                fetchXml += '<condition attribute="statuscode" operator="eq" value="1" />';

                //Provider Specific Filter Criteria: 
                //Check Gender if one of the genders is unchecked, we will search based on the selected gender. 
                if (!male || !female) {
                    if (male) { fetchXml += '<condition attribute="ppms_gender" operator="eq" value="767940002" />' }
                    if (female) { fetchXml += '<condition attribute="ppms_gender" operator="eq" value="767940001" />' }
                };
                //Check if HSRM
                if (hsrm) { fetchXml += '<condition attribute="ppms_contactmethodhsrm" operator="eq" value="1" />' };
                //Check if Primary Care Physician
                if (primarycare) { fetchXml += '<condition attribute="ppms_primarycarephysician" operator="eq" value="1" />' };
                //Check for Accepting New Patients
                if (acceptingnew) { fetchXml += '<condition attribute="ppms_individualisacceptingnewpatients" operator="eq" value="1" />' };
                //Check Primary Care is accepting VA 
                if (acceptingnew) { fetchXml += '<condition attribute="ppms_primarycareprovideracceptingva" operator="eq" value="1" />' };
                fetchXml += '</filter></link-entity>'

                //Retrieve Provider Agreement State/Status Reason values to check if this is a Prov Agreement 
                fetchXml += '<link-entity name="ppms_provideragreement" from="ppms_provideragreementid" to="ppms_provideragreement" visible="false" link-type="outer" alias="a_64728393f394e81181201458d04dc6b8">';
                fetchXml += '<attribute name="statecode"/>';
                fetchXml += '<attribute name="statuscode"/>';

                //Maybe addt his as conditional filter in future. 
                //fetchXml += '<filter type="and">';
                //fetchXml += '<condition attribute="statecode" operator="eq" value="0" />';
                //fetchXml += '<condition attribute="statuscode" operator="eq" value="1" />';
                //fetchXml += '</filter>';
                fetchXml += '</link-entity>';

                fetchXml += '</entity ></fetch >';

                var userQuery = JSON.stringify({
                    "name": "User Defined Provider Query",
                    "description": "User Defined Provider Query from Options Selected.",
                    "returnedtypecode": "ppms_providerservice",
                    "fetchxml": fetchXml,
                    "querytype": 0
                });
                $.ajax({
                    type: "POST",
                    contentType: "application/json; charset=utf-8",
                    datatype: "json",
                    url: webAPIUrl + "userqueries",
                    data: userQuery,
                    beforeSend: function (XMLHttpRequest) {
                        //Specifying this header ensures that the results will be returned as JSON.             
                        XMLHttpRequest.setRequestHeader("Accept", "application/json");
                    },
                    success: function (data, textStatus, xhr) {
                        var parseQuery = /\(([^)]+)\)/;
                        var queryMatches = parseQuery.exec(xhr.getResponseHeader("Odata-EntityId"));
                        userQueryId = queryMatches[1];

                        findProviders();
                    },
                    error: function (e) {
                        showErrorMsg('Unable to generate Query');
                    }
                });
                //fetchXmlEncoded = escape(fetchXml);

            }

        });


        function findProviders() {

            //Generate a Request URL with options to Query CRM Web API data. 
            var number = 25;
            var request = new String();

            //var requestType = "ppms_providerservices?fetchXml=";
            //request += webAPIUrl + requestType + fetchXmlEncoded;
            var requestType = "ppms_providerservices?userQuery=";
            request += webAPIUrl + requestType + userQueryId;

            $.ajax({
                type: "GET",
                contentType: "application/json; charset=utf-8",
                datatype: "json",
                url: request,
                beforeSend: function (XMLHttpRequest) {
                    //Specifying this header ensures that the results will be returned as JSON.             
                    XMLHttpRequest.setRequestHeader("Accept", "application/json");
                },
                success: function (data, textStatus, xhr) {
                    //Establish the initial list from first page of response and then 
                    //call aggregate function to check for more pages in response. 
                    providersList = data.value;
                    aggregateProviders(data, textStatus, xhr);
                },
                error: function (e) {
                    document.getElementById('loaderTitle').style.display = 'none';
                    document.getElementById('loader').style.display = 'none';
                    document.getElementById('resultsPanel').style.display = 'block';
                    showErrorMsg(e.statusText);
                }
            });
        }

        function cleanUpUserQuery() {

            var request = webAPIUrl + "userqueries(" + userQueryId + ")";
            //Delete the userquery that was created. 
            $.ajax({
                type: "DELETE",
                contentType: "application/json; charset=utf-8",
                datatype: "json",
                url: request,
                beforeSend: function (XMLHttpRequest) {
                    //Specifying this header ensures that the results will be returned as JSON.             
                    XMLHttpRequest.setRequestHeader("Accept", "application/json");
                },
                success: function (data, textStatus, xhr) {
                },
                error: function (e) {
                    var error = e;
                }
            });

        }

        function aggregateProviders(data, textStatus, xhr) {
            //Check if we need to add next page of Providers to List. 
            if (data.hasOwnProperty("@odata.nextLink")) {
                var request = new String();
                request = data["@odata.nextLink"];
                $.ajax({
                    type: "GET",
                    contentType: "application/json; charset=utf-8",
                    datatype: "json",
                    url: request,
                    beforeSend: function (XMLHttpRequest) {
                        //Specifying this header ensures that the results will be returned as JSON.             
                        XMLHttpRequest.setRequestHeader("Accept", "application/json");
                    },
                    success: function (data, textStatus, xhr) {
                        //Function to populate all the data from query into one list
                        providersList = providersList.concat(data.value);
                        aggregateProviders(data, textStatus, xhr);
                    },
                    error: function (e) {
                        document.getElementById('loaderTitle').style.display = 'none';
                        document.getElementById('loader').style.display = 'none';
                        document.getElementById('resultsPanel').style.display = 'block';
                        showErrorMsg(e.statusText);
                    }
                });
            }

            else {
                //After going through all pages clean up the User Query. 
                cleanUpUserQuery();

                //IF after applying the filters & aggregation we have Providers, proceed to sorting by distance / radius.
                //Otherwise display a message to the user. 
                if (providersList.length > 0) {
                    filterProviders(providersList);
                } else {
                    document.getElementById('loaderTitle').style.display = 'none';
                    document.getElementById('loader').style.display = 'none';
                    document.getElementById('resultsPanel').style.display = 'block';
                    showErrorMsg('No Providers found matching the Search Criteria. Try updating your Search Criteria or Expand your Search Radius.');
                }
            }
        }

        function filterProviders(providers) {

            //Filter out the Providers outside of the defined Radius.
            var searchRadius = $('#radiusSelection').find(":selected").val();

            //Function that checks various conditons and removes Providers that don't meet conditions
            var filteredProviders = providers.filter(function (provider) {

                //If the Provider has the Prov Agreement Status present , we'll check the Status Code for Active.
                var paStatuscode = $(provider).attr('a_64728393f394e81181201458d04dc6b8_x002e_statuscode');
                if (typeof paStatuscode !== typeof undefined) {
                    if (paStatuscode != 1) { return (false); }
                }

                //Only return Providers with distance less than search radius
                var distance = haversineDistance(searchLocation,
                    new Microsoft.Maps
                        .Location(provider.ppms_latitude, provider.ppms_longitude));
                provider.distance = distance;
                //Only return Providers Distance that's less than search radius
                if (distance > searchRadius) { return (false); }

                //Concatenate the Specialty & Network Name here after checks are passed.
                provider.ppms_specialtynametext = provider.ppms_specialtynametext + '(' + provider.ppms_networknametext + ')';
                return (true);
            });

            if (filteredProviders.length > 0) {

                //Sort the New Provider Array by the distance. 
                filteredProviders.sort(function (a, b) { return a['distance'] - b['distance'] });
                //Slice down to 100 to start if there are providers with multiple specialties. 
                filteredProviders = filteredProviders.slice(0, 100);

                //Modify/Compare elements in the array to see if the Providers/Locations/Specialties are distinct (concatenate specialties as needed)
                //If we have no taxomies(no filter), or multiple selected, we will possibly need to combine providers at the same site with their multiple 
                //specialty info.                 
                if (taxonomies.length == 0 || taxonomies.length >= 2) {
                    for (var p = 0; p < filteredProviders.length; p++) {

                        if (p != filteredProviders.length - 1) {
                            if (filteredProviders[p]._ppms_providerid_value === filteredProviders[p + 1]._ppms_providerid_value
                                && filteredProviders[p].ppms_caresiteaddress === filteredProviders[p + 1].ppms_caresiteaddress
                            ) {
                                //Concatenate Specialty
                                filteredProviders[p + 1].ppms_specialtynametext = filteredProviders[p + 1].ppms_specialtynametext + ', ' + filteredProviders[p].ppms_specialtynametext;
                                //Remove extra Provider Service record.
                                filteredProviders.splice(p, 1);
                                p = p - 1;
                            }
                        }
                    }
                }

                //Distance Matrix Request can take 625 destinations but due to HTTP GET URL limits in most browsers we will 
                //limit to 50 destinations for now. 
                filteredProviders = filteredProviders.slice(0, 50);

                //Define the Route Request / Distance Matrix URL.
                var distanceUnits = 'mi';
                //Format the Start Time. 
                var currentdate = new Date();
                var startTime = currentdate.getHours() + ":"
                    + ('0' + currentdate.getMinutes()).slice(-2) + ":"
                    //  + currentdate.getMinutes() + ":"
                    + currentdate.getSeconds();
                //var startTime = "2019-09-07T13:00:00-07:00";

                var originLatitude = searchLocation.latitude;
                var originLongitude = searchLocation.longitude;
                var origin = originLatitude + "," + originLongitude;
                var routeRequest = 'https://dev.virtualearth.net/REST/v1/Routes/DistanceMatrix?origins='
                //Define the first origin
                routeRequest += origin;
                routeRequest += '&destinations=';
                //Loop through the results and add to destinations
                for (var p = 0; p < filteredProviders.length; p++) {
                    var destinationLatitude = filteredProviders[p].ppms_latitude;
                    var destinationLongitude = filteredProviders[p].ppms_longitude;
                    var destination = destinationLatitude + "," + destinationLongitude;
                    routeRequest += destination;
                    if (p != filteredProviders.length - 1) { routeRequest += ";" };
                }
                routeRequest += '&travelMode=driving';
                //Only add start Time if we have 10 or less Providers to calculate. 
                //Otherwise the request times out. 
                if (filteredProviders.length <= 10) {
                    routeRequest += '&startTime=' + encodeURIComponent(startTime);
                }
                routeRequest +=
                    '&du=' +
                    encodeURIComponent(distanceUnits) +
                    '&key=' +
                    encodeURIComponent(bingMapsKey);

                CallRouteService(routeRequest,
                    filteredProviders,
                    drivingResultsCallback);
            } else {
                document.getElementById('loaderTitle').style.display = 'none';
                document.getElementById('loader').style.display = 'none';
                document.getElementById('resultsPanel').style.display = 'block';
                showErrorMsg('No Providers found matching the Search Criteria. Try updating your Search Criteria or Expand your Search Radius.');
            }
        }

        function CallRouteService(routeRequest, filteredProviders, callback) {
            $.ajax({
                url: routeRequest,
                dataType: "jsonp",
                jsonp: "jsonp",
                success: function (r) {
                    callback(r, filteredProviders);
                },
                error: function (e) {
                    //alert(e.statusText);
                    alert("Driving Route Error: " + e.statusText)
                }
            });
        }

        function drivingResultsCallback(routeResult, filteredProviders) {
            // Do something with the result
            if (routeResult &&
                routeResult.resourceSets &&
                routeResult.resourceSets.length > 0 &&
                routeResult.resourceSets[0].resources &&
                routeResult.resourceSets[0].resources.length > 0) {
                var travelDistanceSet = routeResult.resourceSets[0];
                var routes = travelDistanceSet.resources[0].results;
                var routeDistances = new Array();
                var routeTravelTimes = new Array();
                for (var r = 0; r < routes.length; r++) {
                    //Only add the Even Route Results to the Routes. 
                    //if ((r & 1) == 0) {
                    var routeDrivingDistance = routes[r].travelDistance;
                    routeDrivingDistance = Math.round(routeDrivingDistance * 100) / 100;
                    //Convert to Miles
                    //No longer needed?
                    //routeDrivingDistance = Math.round(routeDrivingDistance * 100) / 100;

                    var routeTravelTime = routes[r].travelDuration;
                    routeTravelTime = Math.round(routeTravelTime);
                    //Convert to Minutes (traffic not included)
                    //No Longer needed?
                    //routeTravelTime = Math.round(routeTravelTime / 60);

                    routeDistances.push(routeDrivingDistance);
                    routeTravelTimes.push(routeTravelTime);
                    // }
                }
                var providerResults = new Array();
                for (var p = 0; p < filteredProviders.length; p++) {
                    //Add the formatted Driving Distance and Travel Time to Provider Results. 
                    filteredProviders[p].drivingDistance = routeDistances[p];
                    filteredProviders[p].drivingTime = routeTravelTimes[p];

                    //Check if Quality Ranking has a value and then update if necessary for the sorting below. 
                    if (filteredProviders[p].ppms_qualityrankingtotalscore == undefined) { filteredProviders[p].ppms_qualityrankingtotalscore = 0 }

                    providerResults.push(filteredProviders[p]);
                }

                //Sort the New Provider Array by the distance and check the Sorting Type that was selected. Default will be driving distance
                switch (sortBySelection) {
                    case '0':
                        //Driving Distance
                        providerResults.sort(function (a, b) { return a['drivingDistance'] - b["drivingDistance"] });
                        break;
                    case '1':
                        //Driving Time
                        providerResults.sort(function (a, b) { return a['drivingTime'] - b["drivingTime"] });
                        break;
                    case '2':
                        //Quality Ranking
                        //From highest to lowest quality ranking                       
                        providerResults.sort(function (a, b) {
                            if (a["ppms_qualityrankingtotalscore"] < b['ppms_qualityrankingtotalscore']) return 1;
                            if (a["ppms_qualityrankingtotalscore"] > b['ppms_qualityrankingtotalscore']) return -1;
                            return 0;
                        })
                        break;
                    case '3':
                        //Specialty Name Alphabetic
                        providerResults.sort(function (a, b) {
                            if (a["ppms_specialtynametext"] < b['ppms_specialtynametext']) return -1;
                            if (a["ppms_specialtynametext"] > b['ppms_specialtynametext']) return 1;
                            return 0;
                        })
                        break;
                    default:
                        //Driving Distance Default
                        providerResults.sort(function (a, b) { return a['drivingDistance'] - b["drivingDistance"] });
                        break;
                }

                AddProvidersToMap(providerResults);
            }
        }


        function AddProvidersToMap(providerResults) {

            //Create an array to store the Provider info passed into function. 
            var providers = providerResults;

            document.getElementById('loaderTitle').style.display = 'none';
            document.getElementById('loader').style.display = 'none';
            document.getElementById('resultsPanel').style.display = 'block';
            // Create the HTML for a single list item for the result.                        
            //listItems.push('<table class="listItem"><tr><th>Provider Details</th><th>Directions & Distance</th></tr><tr><td rowspan="1"></td>');
            listItems.push('<table summary="The order,Provider, Address, Profile Link, Direction, Distance, Drivetime, Specilaty, Netowrk & HSRM Status of Providers" class="listItem table table table-hover table-fixed"><thead><tr><th>#</th><th>Provider</th><th>Directions</th><th>Specialty/Network</th><th>Provider Details</th></tr></thead><tbody>');

            //Add the Search Location as Pin to the map
            var startingLoc = new Microsoft.Maps
                .Location(searchLocation.latitude, searchLocation.longitude);
            // Add the location coordinate to the array of locations
            var startPin = new Microsoft.Maps.Pushpin(startingLoc,
                {
                    icon: null,
                    color: 'blue'
                }
            );
            startingPin.push(startPin);

            //Loop through the Providers and add them to the map. 
            for (var p = 0; p < providers.length; p++) {
                //Define the Provider's Location for the map. 
                var loc = new Microsoft.Maps
                    .Location(providers[p].ppms_latitude, providers[p].ppms_longitude);
                // Add the location coordinate to the array of locations
                locs.push(loc);
                // Create pushpin
                var pin = new Microsoft.Maps.Pushpin(loc,
                    {
                        icon: null,
                        //text: (locs.length) + ''
                    }
                );
                // Store the location result info as a property of the pushpin so we can use it later.
                pin.Metadata = providers[p];
                // Add a click event to the pushpin to display an infobox.
                Microsoft.Maps.Events.addHandler(pin,
                    'mouseover',
                    function (e) {
                        displayInfobox(e.target);
                    });
                /*
                Microsoft.Maps.Events.addHandler(pin,
                    'mouseout',
                    function (e) {
                        hideInfobox(e.target);
                    });
                */
                // Add the pushpin to the pin layer. 
                pins.push(pin);

                //Check if the Provider has a Quality Ranking value before displaying it. NR = No Quality Rating defi
                qualityRanking = 'NR';
                if (providers[p].ppms_qualityrankingtotalscore !== 0) { qualityRanking = providers[p].ppms_qualityrankingtotalscore };

                hsrmText = '';
                if (providers[p].ppms_hsrm == 1) { hsrmText = 'HSRM' };

                // Store the result ID as a property of the name. This will allow us to relate the list item to the pushpin on the map.
                listItems.push('<tr>');
                listItems.push('<th scope="row">' + locs.length + '</th>')

                listItems
                    .push('<td><a class="title" href="javascript:void(0);" rel="',
                        providers[p].ppms_providerserviceid, '">',
                        providers[p].ppms_providername,
                        '</a><br/>' + '<a id="providerAddressText" href="#">', providers[p].ppms_caresiteaddress, '<br/>', providers[p].ppms_caresitecity, ",", providers[p].ppms_caresitestateprovince, '<br/>', providers[p].ppms_caresitezipcode, '</a>'
                    );
                listItems.push(
                    '<br/>',
                    '<a alt="Profile for ', providers[p].ppms_providername, '" title="Profile for ', providers[p].ppms_providername, '" id="providerProfile" class="viewprofile" href="javascript:void(0);" rel="',
                    providers[p]._ppms_providerid_value,
                    '">',
                    "View Profile",
                    '</a></td>');
                listItems
                    .push('<td><a alt="Directions for ', providers[p].ppms_providername, '" title="Directions for ', providers[p].ppms_providername, '" target="_blank" href="https://bing.com/maps/default.aspx?rtp=adr.',
                        veteranLocation,
                        '~pos.',
                        pin.Metadata.ppms_latitude,
                        '_',
                        pin.Metadata.ppms_longitude,
                        '_',
                        encodeURIComponent(pin.Metadata.ppms_providername),
                        '">Directions</a> <br/>' + '<a id="drivingDistanceText" href="#">', providers[p].drivingDistance, ' ', distanceUnits, '</a><br/>'

                        + '<a id="drivingTimeText" href="#">', providers[p].drivingTime, ' ', 'min', '</a></td>');
                listItems
                    .push('<td><a id="specialtyNetworkText" href="#">', providers[p].ppms_specialtynametext, '</a></td>');
                listItems
                    .push('<td><a id="hsrmText" href="#">', hsrmText, '</a><br/>', '<a id="QRText" href="#">', qualityRanking, '</a></td>');

            }
            listItems.push('</tr>');
            listItems.push('</tbody>');
            listItems.push('</table>');

            var startingPinlayer = new Microsoft.Maps.Layer();
            startingPinlayer.add(startingPin);
            map.layers.insert(startingPinlayer);

            var clusterLayer = new Microsoft.Maps.ClusterLayer(pins, {
                clusteredPinCallback: createCustomClusteredPin,
                gridSize: 1
            });
            map.layers.insert(clusterLayer);

            // Use the array of locations from the results to set the map view to show all locations.
            if (locs.length > 1) {
                map
                    .setView({
                        bounds: Microsoft.Maps.LocationRect.fromLocations(locs),
                        padding: 80
                    });
            } else {
                map.setView({ center: locs[0], zoom: 15 });
            }

            // Add the list items to the results panel.
            $('.resultsPanel').html(listItems.join(''));

            // Add a click event to the title of each list item.
            $('.title').click(function () {
                // Get the ID of the selected location
                var id = $(this).attr('rel');
                //Loop through all the pins in the data layer and find the pushpin for the location.
                var pin;
                for (var i = 0; i < pins.length; i++) {
                    pin = pins[i];
                    if (pin.Metadata.ppms_providerserviceid != id) {
                        pin = null;
                    } else {
                        break;
                    }
                }
                // If a pin is found with a matching ID, then center the map on it and show it's infobox.
                if (pin) {
                    // Offset the centering to account for the infobox.
                    map.setView({
                        center: pin.getLocation(),
                        centerOffset: new Microsoft.Maps.Point(-70, 150),
                        zoom: 17
                    });
                    displayInfobox(pin);
                }
            });
            $('.viewprofile').click(function () {
                // Get the ID of the selected Provider
                var id = $(this).attr('rel');
                var windowOptions = {
                    openInNewWindow: true
                };
                Xrm.Utility.openEntityForm("account", id, null, windowOptions)
            });
        }

        function createCustomClusteredPin(cluster) {
            //Define variables for minimum cluster radius, and how wide the outline area of the circle should be.
            var minRadius = 12;
            var outlineWidth = 7;
            //Get the number of pushpins in the cluster
            var clusterSize = cluster.containedPushpins.length;
            //Calculate the radius of the cluster based on the number of pushpins in the cluster, using a logarithmic scale.
            var radius = Math.log(clusterSize) / Math.log(10) * 5 + minRadius;
            //Default cluster color is red.
            var fillColor = 'rgba(255, 40, 40, 0.5)';
            if (clusterSize < 10) {
                //Make the cluster green if there are less than 10 pushpins in it.
                fillColor = 'rgba(73, 73, 73, 0.5)';
            }
            else if (clusterSize < 100) {
                //Make the cluster yellow if there are 10 to 99 pushpins in it.
                fillColor = 'rgba(0, 0, 0, 0.5)';
            }
            //Create an SVG string of two circles, one on top of the other, with the specified radius and color.
            var svg = ['<svg xmlns="http://www.w3.org/2000/svg" width="', (radius * 2), '" height="', (radius * 2), '">',
                '<circle cx="', radius, '" cy="', radius, '" r="', radius, '" fill="', fillColor, '"/>',
                '<circle cx="', radius, '" cy="', radius, '" r="', radius - outlineWidth, '" fill="', fillColor, '"/>',
                '</svg>'];
            //Customize the clustered pushpin using the generated SVG and anchor on its center.
            cluster.setOptions({
                name: "Multiple",
                icon: svg.join(''),
                anchor: new Microsoft.Maps.Point(radius, radius),
                textOffset: new Microsoft.Maps.Point(0, radius - 8) //Subtract 8 to compensate for height of text.
            });

            //Add click event to clustered pushpin
            Microsoft.Maps.Events.addHandler(cluster, 'click', clusterClicked);
            Microsoft.Maps.Events.addHandler(cluster, 'mouseover', clusterClicked);
            //Microsoft.Maps.Events.addHandler(cluster, 'mouseout', hideClusterInfobox);
        }

        function clusterClicked(e) {
            if (e.target.containedPushpins) {
                var prov1 = e.target.containedPushpins[0].Metadata;
                var providers = e.target.containedPushpins;
                var title = prov1.ppms_caresiteaddress + ' ' + prov1.ppms_caresitecity + ', ' + prov1.ppms_caresitestateprovince + ' ' + prov1.ppms_caresitezipcode;
                var description = buildClusterInfoboxDescription(providers);
                //Display the custom infobox with generated info above. 
                clusterInfobox.setLocation(e.target.containedPushpins[0].getLocation());
                //clusterInfobox.setOptions({ visible: true, title: title, description: description }); 
                clusterInfobox.setOptions({ visible: true, description: description });

                //Close Cluster Infobox Action
                $('.closeClusterInfobox').click(function () {
                    clusterInfobox.setOptions({ visible: false });
                });

                $('.viewclusterprofile').click(function () {
                    // Get the ID of the selected Provider
                    var id = $(this).attr('rel');
                    var windowOptions = {
                        openInNewWindow: true
                    };
                    Xrm.Utility.openEntityForm("account", id, null, windowOptions)
                });

            }
        }

        // Takes a pushpin and generates the content for the infobox from the Metadata and displays the infobox.
        function buildClusterInfoboxDescription(providers) {
            infobox.setOptions({ visible: false });
            var desc = ['<table>'];
            //Location Address (same for all providers below)
            desc.push('<tr><td><a id="clusterInfoBoxAddressText" href="#"><b>', providers[0].Metadata.ppms_caresiteaddress, '<br/>', providers[0].Metadata.ppms_caresitecity, ",", providers[0].Metadata.ppms_caresitestateprovince, ' ', providers[0].Metadata.ppms_caresitezipcode, '</b></a></td></tr><tr></tr>');

            for (var i = 0, len = providers.length; i < len; i++) {

                //Build Provider Details: HSRM & QR
                var clusterInfoBoxQualityRanking = 'NR';
                if (providers[i].Metadata.ppms_qualityrankingtotalscore !== 0) { clusterInfoBoxQualityRanking = providers[i].Metadata.ppms_qualityrankingtotalscore };
                var clusterInfoBoxHsrmText = '';
                if (providers[i].Metadata.ppms_hsrm == 1) { clusterInfoBoxHsrmText = 'HSRM' };
                var clusterInfoBoxProviderDetailsText = '';
                clusterInfoBoxProviderDetailsText += clusterInfoBoxQualityRanking;
                if (clusterInfoBoxHsrmText !== "") { clusterInfoBoxProviderDetailsText += ', '; clusterInfoBoxProviderDetailsText += clusterInfoBoxHsrmText; }

                //Provider Name
                desc.push('<tr><td colspan="2"><b>______________</b></td></tr>');
                desc.push('<tr><td colspan="2"><a id="clusterInfoBoxProviderNameText" href="#">', providers[i].Metadata.ppms_providername, '</a></td></tr>');
                //Hours
                //desc.push('<tr><td><a id="clusterInfoBoxHoursText" href="#"><b>Hours:</b>', providers[i].Metadata.ppms_workhours, '</a></td></tr>');
                //Specialty/Network
                desc.push('<tr><td><a id="clusterInfoBoxSpecialtyNetworkText" href="#"><b>Specialty/Network:</b>', providers[i].Metadata.ppms_specialtynametext, '</a></td></tr>');
                //Provider Details
                desc.push('<tr><td><a id="clusterInfoBoxProviderDetailsText" href="#"><b>Provider Details:</b>', clusterInfoBoxProviderDetailsText, '</a></td></tr>');
                //View Profile
                desc.push('<tr><td><a alt="Profile for ', providers[i].Metadata.ppms_providername, '" title="Profile for ', providers[i].Metadata.ppms_providername, '" id="providerClusterProfile" class="viewclusterprofile" href="javascript:void(0);" rel="',
                    providers[i].Metadata._ppms_providerid_value, '">', "Profile ", '</a>');
                //Directions
                desc.push('<a alt="Directions for ', providers[i].Metadata.ppms_providername, '" title="Directions for ', providers[i].Metadata.ppms_providername, '" target="_blank" href="https://bing.com/maps/default.aspx?rtp=adr.',
                    veteranLocation, '~pos.', providers[i].Metadata.ppms_latitude, '_', providers[i].Metadata.ppms_longitude, '_', encodeURIComponent(providers[i].Metadata.ppms_providername), '">Directions</a></td></tr>');
            }
            //Close Infobox
            desc.push('<tr><td><br/><a alt="Close Cluster Infobox" title="Close Cluster Infobox" class="closeClusterInfobox" href="javascript:void(0);" rel="', providers, '">', "Close Infobox", '</a></td></tr>');
            //Close Table
            desc.push('</table>');
            var providerdescriptions = desc.join('');
            return providerdescriptions;
        }


        // Takes a pushpin and generates the content for the infobox from the Metadata and displays the infobox.
        function displayInfobox(pin) {
            clusterInfobox.setOptions({ visible: false });
            infobox.setLocation(pin.getLocation());

            //Build Provider Details: HSRM & QR
            var infoBoxQualityRanking = 'NR';
            if (pin.Metadata.ppms_qualityrankingtotalscore !== 0) { infoBoxQualityRanking = providers[p].ppms_qualityrankingtotalscore };
            var infoBoxHsrmText = '';
            if (pin.Metadata.ppms_hsrm == 1) { infoBoxHsrmText = 'HSRM' };
            var infoBoxProviderDetailsText = '';
            infoBoxProviderDetailsText += infoBoxQualityRanking;
            if (infoBoxHsrmText !== "") { infoBoxProviderDetailsText += ', '; infoBoxProviderDetailsText += infoBoxHsrmText;}

            //Build Table Start
            var desc = ['<table>'];
            //Title/Provider Name
            desc.push('<tr><td><a id="infoBoxTitleText" href="#"><b>', pin.Metadata.ppms_providername, '</b></a></td></tr>');
            //Address
            desc.push('<tr><td><a id="infoBoxAddressText" href="#">', pin.Metadata.ppms_caresiteaddress, '<br/>', pin.Metadata.ppms_caresitecity, ",", pin.Metadata.ppms_caresitestateprovince, ' ', pin.Metadata.ppms_caresitezipcode, '</a></td></tr>');
            //Hours
            //desc.push('<tr><td><a id="infoBoxHoursText" href="#"><b>Hours:</b>', pin.Metadata.ppms_workhours, '</a></td></tr>');
            //Specialty/Network
            desc.push('<tr><td><a id="infoBoxSpecialtyNetworkText" href="#"><b>Specialty/Network:</b>', pin.Metadata.ppms_specialtynametext, '</a></td></tr>');
            //Provider Details HSRM/QR
            desc.push('<tr><td><a id="infoBoxProviderDetailsText" href="#"><b>Provider Details:</b>', infoBoxProviderDetailsText, '</a></td></tr>');

            //View Profile
            desc.push('<tr><td><a alt="Profile for ', pin.Metadata.ppms_providername, '" title="Profile for ', pin.Metadata.ppms_providername, '" id="providerProfile" class="viewprofile" href="javascript:void(0);" rel="',
                pin.Metadata._ppms_providerid_value, '">', "Profile ", '');
            //Directions
            desc.push('<a alt="Directions for ', pin.Metadata.ppms_providername, '" title="Directions for ', pin.Metadata.ppms_providername, '" target="_blank" href="https://bing.com/maps/default.aspx?rtp=adr.',
                veteranLocation, '~pos.', pin.Metadata.ppms_latitude, '_', pin.Metadata.ppms_longitude, '_', encodeURIComponent(pin.Metadata.ppms_providername), '">Directions  </a>');
            //Close Infobox
            desc.push('<a alt="Close Infobox" title="Close Infobox" class="closeInfobox" href="javascript:void(0);" rel="', pin, '">', " Close", '</a></td></tr>');
            //Close Table
            desc.push('</table>');

            //infobox.setOptions({ visible: true, title: pin.Metadata.ppms_providername, description: desc.join('') });
            infobox.setOptions({ visible: true, description: desc.join('') });

            //Close Infobox Action
            $('.closeInfobox').click(function () {
                infobox.setOptions({ visible: false });
            });
            $('.viewprofile').click(function () {
                // Get the ID of the selected Provider
                var id = $(this).attr('rel');
                var windowOptions = {
                    openInNewWindow: true
                };
                Xrm.Utility.openEntityForm("account", id, null, windowOptions)
            });
        }

        function hideInfobox(pin) {
            infobox.setLocation(pin.getLocation());
            infobox.setOptions({ visible: false });
        }

        function hideClusterInfobox(e) {
            if (e.target.containedPushpins) {
                clusterInfobox.setLocation(e.target.containedPushpins[0].getLocation());
                clusterInfobox.setOptions({ visible: false });
            }
        }
    }
});